from django.urls import path
from .views import *


urlpatterns = [
    path("register/", ClubRegistration.as_view(), name="club_registration"),
    path("dashboard/", ClubDashboardView.as_view(), name="club_dashboard"),
    path("resubmit/", ClubResubmitView.as_view(), name="club_resubmit"),
    path("officials/home/", ClubOfficialHomeView.as_view(),
         name="club_official_home"),
    path("officials/list/", ClubOfficialsView.as_view(), name="club_official_list"),

    path("official/<int:pk>/update-status/",
         update_official_status, name="update_official_status"),
    path('officials/create/', official_create, name='official_create'),
    path('officials/<int:pk>/update/', official_update, name='official_update'),
    path('officials/<int:pk>/', official_detail, name='official_detail'),
    path('officials/<int:pk>/delete/', official_delete, name='official_delete'),

]
