

from django.urls import path
from core.views import ClubLoginView, LandingPageView, LogoutView, ForbiddenPageView
from club.views import ClubRegistration
from django.contrib.auth import views as auth_views


urlpatterns = [
    path("", LandingPageView.as_view(), name="landing_page"),
    path("forbidden", ForbiddenPageView.as_view(), name="forbidden_page"),
    path("login/", ClubLoginView.as_view(), name="login_page"),
    path("logout/", LogoutView.as_view(), name="club_logout"),
    path('club/password-reset/done/', auth_views.PasswordResetDoneView.as_view(
        template_name='club_password_reset_done.html'
    ), name='club_password_reset_done'),

    path('club/reset/<uidb64>/<token>/', auth_views.PasswordResetConfirmView.as_view(
        template_name='club_password_reset_confirm.html'
    ), name='club_password_reset_confirm'),

    path('club/reset/done/', auth_views.PasswordResetCompleteView.as_view(
        template_name='club_password_reset_complete.html'
    ), name='club_password_reset_complete'),
]
