from django import forms
from .models import Player

class PlayerForm(forms.ModelForm):
    class Meta:
        model = Player
        exclude = ['player_id', 'status', 'reg_year', 'season', 'club', "updated_at", "date_created", "rejection_message"]



class PlayerUpdateForm(forms.ModelForm):
    class Meta:
        model = Player
        exclude = [
            'club', 'player_id', 'reg_year', 'status',
            'season', 'date_created', 'updated_at', 'rejection_message'
        ]
        widgets = {
            'date_of_birth': forms.DateInput(attrs={'type': 'date'}),
            'date_left_last_club': forms.DateInput(attrs={'type': 'date'}),
            'contract_expiry': forms.DateInput(attrs={'type': 'date'}),
        }

    def clean(self):
        cleaned_data = super().clean()
        is_minor = cleaned_data.get("is_minor")
        consent = cleaned_data.get("parental_consent")

        if is_minor and not consent:
            self.add_error("parental_consent", "Parental consent is required for minors.")